JointMaker = class()

function JointMaker:init()
end

function JointMaker:pointThatTwoBodiesRevolveAround(x, y, bodyA, bodyB)
    return physics.joint(REVOLUTE, bodyA, bodyB, vec2(x, y))
end

function JointMaker:barBetweenBodies(bodyA, bodyB, anchorOfBodyA, anchorOfBodyB)
    return physics.joint(DISTANCE, bodyA, bodyB, anchorOfBodyA, anchorOfBodyB)
end

function JointMaker:keepBodiesOnRailDefinedByPoints(bodyA, bodyB, axisPoint1, axisPoint2)
    return physics.joint(PRISMATIC, bodyA, bodyB, axisPoint1, axisPoint2)
end

function JointMaker:weldBodiesTogether(bodyA, bodyB, weldPointBodyA, weldPointBodyB)
    if not weldPointBodyB then weldPointBodyB = weldPointBodyA end
    return physics.joint(WELD, bodyA, bodyB, weldPointBodyA, weldPointBodyB)
end

function JointMaker:motorizedJoint(bodyA, bodyB, maxTorque, locationOfJoint)
    locationOfJoint = locationOfJoint or bodyA.position
    local motor = physics.joint(REVOLUTE, bodyA, bodyB, locationOfJoint)
    motor.maxMotorTorque = maxTorque or 250
    motor.enableMotor = true
    return motor
end
